# Open Data files for Clean Clothes Campaign


This ZIP file contains files for studying and researching about this participation platform.


## Core

### users

* id: The unique identifier of the user
* name: The display name of user
* nickname: The username of the user
* about: The about text of the user
* avatar_url: The avatar of the user
* profile_url: The profile url
* direct_messages_enabled: Whether the user allows direct messages
* deleted: Whether the user is deleted or not
* badge: The badge of the user
* groups: The id and name of the user group


### metrics

* day: The day this metric was created
* metric_type: The type of the metric
* cumulative: The total number of the metric at this day
* quantity: The number of the metrics for this day


### taxonomies

* id: The unique identifier of this taxonomy
* name: The name of this taxonomy
* parent_id: The unique identifiers of this taxonomy parent (if any)
* weight: The order in which this taxonomy is shown
* children_count: The count of the children that this taxonomy has
* taxonomizations_count: The count of the resources that use this taxonomy
* created_at: The date when this taxonomy was created
* updated_at: The date when this taxonomy was updated for the last time
* filters_count: The number of filters that is using this taxonomy
* filter_items_count: The number of items filters that are using this taxonomy
* part_of: Used to detect if this taxonomy is part of another taxonomy
* is_root: True if this taxonomy do not have any parent



## Spaces

### participatory_processes

* id: The unique identifier of this process
* title: The process title
* slug: The process slug (used for identification purposes, for the URL)
* reference: The unique reference of the space
* created_at: The date this space was created
* updated_at: The last date this space was updated
* published_at: The date this space was published
* follows_count: The number of users following this space
* hashtag: The process hashtag, used for Twitter/X
* short_description: A short description of the process
* description: A long description of the process
* promoted: Wheter the process is promoted or not
* url: The URL of the space
* subtitle: The subtitle of the process
* remote_hero_image_url: The URL of the process hero image
* announcement: The announcement (callout) information
* start_date: The start date of the process
* end_date: The end date of the process
* developer_group: The developer group of the process. This is the organization that is promoting the process.
* local_area: The local area of the process. This is the organization area where the process is taking place.
* meta_scope: The scope metadata of the process
* participatory_scope: The participatory scope of the process
* participatory_structure: The participatory structure of the process. This is how the process is decided.
* target: The target of the process. This is who is called to participate in the process.
* area: The area where the process is taking place
* participatory_process_group: The group of the process, if there is any
* scope: The scope of the process
* scopes_enabled: Whether the scopes are enabled or not
* participatory_process_type: The type of the process


### conferences

* id: The unique identifier of this conference
* title: The conference title
* slug: The conference slug (used for identification purposes, for the URL)
* reference: The unique reference of the space
* created_at: The date this space was created
* updated_at: The last date this space was updated
* published_at: The date this space was published
* follows_count: The number of users following this space
* hashtag: The conference hashtag, used for Twitter/X
* short_description: A short description of the conference
* description: A long description of the conference
* promoted: Wheter the conference is promoted or not
* url: The URL of the space
* slogan: The slogan for this conference
* remote_hero_image_url: The URL of the conference hero image
* remote_banner_image_url: The URL of the conference banner image
* location: The conference location. Where this conference will take place.
* objectives: The objectives for this conference. What is the goal.
* start_date: The date when this conference starts.
* end_date: The date when this conference ends.
* scopes_enabled: Weather the scopes are enabled or not
* decidim_scope_id: The scope of the conference
* scope: The scope of the conference



## Components

### debates

* id: The unique identifier of the debate
* author: The data for the author of this debate
* title: The debate title
* description: The debate description
* instructions: Which are the instructions to comment in this debate
* start_time: When this debate starts, if it is an open debate and has a limited time
* end_time: When this debate ends, if it is an open debate and has a limited time
* information_updates: The updates that the author has made to the debate
* taxonomies: The taxonomies of the project
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this debate belongs to
* component: The component that the debate belongs to
* reference: The unique identifier of the resource in this platform
* comments: The number of comments this debate has
* follows_count: The number of followers this debate has
* url: The URL where this debate can be found
* last_comment_at: The date when this debate was commented by the last time
* last_comment_by: The data of last comment made within the debate
* comments_enabled: Wether this debate has comments enabled or not
* conclusions: The conclusions of the debate if it was closed
* closed_at: The date when this debate was closed
* created_at: The date and time when the debate was created
* updated_at: The date of when the debate was last updated
* endorsements_count: The number of endorsements the debate has


### pages

* id: The unique identifier of this page
* title: The page title
* body: The body of the page
* created_at: The date this page was created
* updated_at: The last date this page was updated
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this page belongs to
* component: The component that the page belongs to
* url: The URL for this page



